local Aloft = Aloft
if not Aloft then return end
if not AloftLocale then return end

-----------------------------------------------------------------------------

local dL = { }

local oL = { }

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings

--[[ enUS ]] dL["rare"]				= "Rare"
--[[ enUS ]] dL["elite"]			= "Elite"
--[[ enUS ]] dL["rareelite"]		= "Rare-Elite"
--[[ enUS ]] dL["worldboss"]		= "Boss"

--[[ enUS ]] dL["shortrare"]		= "r"
--[[ enUS ]] dL["shortelite"]		= "+"
--[[ enUS ]] dL["shortrareelite"]	= "r+"
--[[ enUS ]] dL["shortworldboss"]	= "b"

--[[ enUS ]] dL["Unknown"]			= "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ enUS ]] oL["Save Classification Data"] = "Save Classification Data"
--[[ enUS ]] oL["Stores unit classification information between sessions"] = "Stores unit classification information between sessions"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

--[[ koKR ]] dL["rare"]				= "희귀"
--[[ koKR ]] dL["elite"]			= "정예"
--[[ koKR ]] dL["rareelite"]		= "희귀-정예"
--[[ koKR ]] dL["worldboss"]		= "보스"

--[[ koKR ]] dL["shortrare"]		= "r"
--[[ koKR ]] dL["shortelite"]		= "+"
--[[ koKR ]] dL["shortrareelite"]	= "r+"
--[[ koKR ]] dL["shortworldboss"]	= "b"

--[[ koKR ]] dL["Unknown"]			= "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ koKR ]] oL["Save Classification Data"] = "구분 데이터 저장"
--[[ koKR ]] oL["Stores unit classification information between sessions"] = "각 접속간 대상의 구분 정보를 저장합니다."

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

--[[ ruRU ]] dL["rare"]				= "Редкий"
--[[ ruRU ]] dL["elite"]			= "Элита"
--[[ ruRU ]] dL["rareelite"]		= "Редкий-Элита"
--[[ ruRU ]] dL["worldboss"]		= "Босс"

--[[ ruRU ]] dL["shortrare"]		= "р"
--[[ ruRU ]] dL["shortelite"]		= "+"
--[[ ruRU ]] dL["shortrareelite"]	= "р+"
--[[ ruRU ]] dL["shortworldboss"]	= "б"

--[[ ruRU ]] dL["Unknown"]			= "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ ruRU ]] oL["Save Classification Data"] = "Записать данные о классификации"
--[[ ruRU ]] oL["Stores unit classification information between sessions"] = "Сохранять данные по классификации объектов между сессиями"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

--[[ zhCN ]] dL["rare"]				= "稀有"
--[[ zhCN ]] dL["elite"]			= "精英"
--[[ zhCN ]] dL["rareelite"]		= "稀有精英"
--[[ zhCN ]] dL["worldboss"]		= "首领"

--[[ zhCN ]] dL["shortrare"]		= "-"
--[[ zhCN ]] dL["shortelite"]		= "+"
--[[ zhCN ]] dL["shortrareelite"]	= "++"
--[[ zhCN ]] dL["shortworldboss"]	= "boss"

--[[ zhCN ]] dL["Unknown"]			= "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ zhCN ]] oL["Save Classification Data"] = "储存分类信息"
--[[ zhCN ]] oL["Stores unit classification information between sessions"] = "在两次登录的间隔储存分类信息"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

--[[ zhTW ]] dL["rare"]				= "稀有"
--[[ zhTW ]] dL["elite"]			= "精英"
--[[ zhTW ]] dL["rareelite"]		= "稀有-精英"
--[[ zhTW ]] dL["worldboss"]		= "首領"

--[[ zhTW ]] dL["shortrare"]		= "稀"
--[[ zhTW ]] dL["shortelite"]		= "+"
--[[ zhTW ]] dL["shortrareelite"]	= "稀+"
--[[ zhTW ]] dL["shortworldboss"]	= "首"

--[[ zhTW ]] dL["Unknown"]			= "Unknown" -- unit name for "Unknown" units

-----------------------------------------------------------------------------

--[[ zhTW ]] oL["Save Classification Data"] = "儲存分類資料"
--[[ zhTW ]] oL["Stores unit classification information between sessions"] = "儲存分類資料"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftLocale.AloftClassificationData = setmetatable(dL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
dL = nil

AloftLocale.AloftClassificationDataOptions = setmetatable(oL, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
oL = nil
