local Aloft = Aloft
if not Aloft then return end
if not Aloft:GetModule("SpellIcon", true) then return end
if not AloftLocale or not AloftLocale.AloftSpellIconOptions then return end

-----------------------------------------------------------------------------

local AloftSpellIcon = Aloft:GetModule("SpellIcon")

local L = AloftLocale.AloftSpellIconOptions

-----------------------------------------------------------------------------

Aloft.Options.args.castBar.args.spellIcon =
{
	type = 'group',
	name = L["Spell Icon"],
	desc = L["Spell icon placement options"],
	disabled = function(i) return not Aloft:IsEnabled() or not AloftSpellIcon:IsEnabled() or not AloftSpellIcon.db or not AloftSpellIcon.db.profile or GetCVar("ShowVKeyCastbar") ~= "1" end,
	order = -1,
	args =
	{
		enable =
		{
			type = 'toggle',
			width = 'full',
			name = L["Enable"],
			desc = L["Enable spell icon display on the nameplate"],
			get = function(i) return AloftSpellIcon.db.profile.enable end,
			set = function(i, v) AloftSpellIcon.db.profile.enable = v AloftSpellIcon:UpdateAll() end,
			order = 1
		},
		position =
		{
			type = 'group',
			name = L["Position"],
			desc = L["Adjust spell icon position"],
			disabled = function(i) return not Aloft:IsEnabled() or not AloftSpellIcon:IsEnabled() or not AloftSpellIcon.db or not AloftSpellIcon.db.profile or GetCVar("ShowVKeyCastbar") ~= "1" or not AloftSpellIcon.db.profile.enable end,
			args =
			{
				anchor = {
					type = 'select',
					width = 'full',
					name = L["Anchor"],
					desc = L["Sets the anchor for the spell icon"],
					get = function(i) return AloftSpellIcon.db.profile.point end,
					set = function(i, v) AloftSpellIcon.db.profile.point = v AloftSpellIcon:UpdateAll() end,
					values = {["TOPLEFT"] = L["TOPLEFT"], ["TOP"] = L["TOP"], ["TOPRIGHT"] = L["TOPRIGHT"], ["LEFT"] = L["LEFT"], ["CENTER"] = L["CENTER"], ["RIGHT"] = L["RIGHT"], ["BOTTOMLEFT"] = L["BOTTOMLEFT"], ["BOTTOM"] = L["BOTTOM"], ["BOTTOMRIGHT"] = L["BOTTOMRIGHT"]},
				},
				anchorto = {
					type = 'select',
					width = 'full',
					name = L["Anchor To"],
					desc = L["Sets the relative point on the cast bar to anchor the spell icon"],
					get = function(i) return AloftSpellIcon.db.profile.relativeToPoint end,
					set = function(i, v) AloftSpellIcon.db.profile.relativeToPoint = v AloftSpellIcon:UpdateAll() end,
					values = {["TOPLEFT"] = L["TOPLEFT"], ["TOP"] = L["TOP"], ["TOPRIGHT"] = L["TOPRIGHT"], ["LEFT"] = L["LEFT"], ["CENTER"] = L["CENTER"], ["RIGHT"] = L["RIGHT"], ["BOTTOMLEFT"] = L["BOTTOMLEFT"], ["BOTTOM"] = L["BOTTOM"], ["BOTTOMRIGHT"] = L["BOTTOMRIGHT"]},
				},
				offsetX =
				{
					type = 'range',
					width = 'full',
					name = L["X Offset"],
					desc = L["X offset of the spell icon"],
					min = -32,
					max = 32,
					step = 1,
					get = function(i) return AloftSpellIcon.db.profile.offsetX end,
					set = function(i, v) AloftSpellIcon.db.profile.offsetX = v AloftSpellIcon:UpdateAll() end
				},
				offsetY =
				{
					type = 'range',
					width = 'full',
					name = L["Y Offset"],
					desc = L["Y offset of the spell icon"],
					min = -32,
					max = 32,
					step = 1,
					get = function(i) return AloftSpellIcon.db.profile.offsetY end,
					set = function(i, v) AloftSpellIcon.db.profile.offsetY = v AloftSpellIcon:UpdateAll() end
				},
			},
		},
		size =
		{
			type = 'range',
			width = 'full',
			name = L["Size"],
			desc = L["Size in pixels of the spell icon"],
			min = 4,
			max = 32,
			step = 1,
			disabled = function(i) return GetCVar("ShowVKeyCastbar") ~= "1" or not AloftSpellIcon.db.profile.enable end,
			get = function(i) return AloftSpellIcon.db.profile.size end,
			set = function(i, v) AloftSpellIcon.db.profile.size = v AloftSpellIcon:UpdateAll() end
		},
		shield =
		{
			type = 'group',
			width = 'full',
			name = L["Shield"],
			desc = L["Shows a shield graphic around an uninterruptable spell icon"],
			disabled = function(i) return not Aloft:IsEnabled() or not AloftSpellIcon:IsEnabled() or not AloftSpellIcon.db or not AloftSpellIcon.db.profile or GetCVar("ShowVKeyCastbar") ~= "1" or not AloftSpellIcon.db.profile.enable end,
			args =
			{
				enable =
				{
					type = 'toggle',
					width = 'full',
					name = L["Enable"],
					desc = L["Enables the shield graphic"],
					get = function(i) return AloftSpellIcon.db.profile.nointerShield end,
					set = function(i, v)
						AloftSpellIcon.db.profile.nointerShield = v
						AloftSpellIcon:UpdateAll()
					end,
				},
				style =
				{
					type = 'select',
					width = 'full',
					name = L["Style"],
					desc = L["Sets the shield graphic style"],
					order = 8,
					disabled = function(i) return not AloftSpellIcon.db.profile.enable or not AloftSpellIcon.db.profile.nointerShield end,
					get = function(i) return AloftSpellIcon.db.profile.nointerStyle end,
					set = function(i, v) AloftSpellIcon.db.profile.nointerStyle = v AloftSpellIcon:UpdateAll() end,
					values =
					{
						["ROUND"]				= L["ROUND"],
						["SQUARE"]				= L["SQUARE"],
					},
				},
				color =
				{
					type = 'color',
					width = 'full',
					name = L["Color"],
					desc = L["Sets the shield graphic color"],
					order = 1,
					disabled = function(i) return not AloftSpellIcon.db.profile.enable or not AloftSpellIcon.db.profile.nointerShield end,
					get = function(i) return unpack(AloftSpellIcon.db.profile.nointerColor) end,
					set = function(i, r, g, b, a) AloftSpellIcon.db.profile.nointerColor = { r, g, b, a } AloftSpellIcon:UpdateAll() end,
					hasAlpha = true,
				},
			},
		},
	},
}

-----------------------------------------------------------------------------
