-----------------------------------------------------------------------------

-- global Aloft locale "table-of-metatables"; this is allocated once here
AloftLocale = { }

-----------------------------------------------------------------------------

local L = { }

-----------------------------------------------------------------------------

-- TODO: on the surface, this wastes space in the enUS locale; the metatable could just return the canonical string as the localization;
--       BUT, this serves as a default locale, and also will permit the metatable to check/notify on missing locale strings
--[[ enUS ]] L["Aloft"] = "Aloft"
--[[ enUS ]] L["Unknown"] = "Unknown" -- unit name for "Unknown" units

--[[ enUS ]] L["Enable Startup Message"] = "Enable Startup Message"

--[[ enUS ]] L["Nameplate Initialization Interval"] = "Nameplate Initialization Interval"
--[[ enUS ]] L["The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"] = "The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"

--[[ enUS ]] L["Class Colors"] = "Class Colors"
--[[ enUS ]] L["Customize class colors"] = "Customize class colors"
--[[ enUS ]] L["class color"] = "class color"
--[[ enUS ]] L["Reset to Defaults"] = "Reset to Defaults"
--[[ enUS ]] L["Resets all colors to their defaults"] = "Resets all colors to their defaults"

-- labels for keybindings; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ enUS ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ enUS ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ enUS ]] L["Show All Name Plates"] = "Show All Name Plates"

-- player states; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ enUS ]] L["Combat"] = "Combat"
--[[ enUS ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ enUS ]] L["Resting"] = "Resting"
--[[ enUS ]] L["Group"] = "Group"
--[[ enUS ]] L["Default"] = "Default"

-- player locations; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ enUS ]] L["Player Location"] = "Player Location"
--[[ enUS ]] L["World"] = "World"
--[[ enUS ]] L["Battleground"] = "Battleground"
--[[ enUS ]] L["Arena"] = "Arena"
--[[ enUS ]] L["5-Man Instance"] = "5-Man Instance"
--[[ enUS ]] L["Raid Instance"] = "Raid Instance"

--[[ enUS ]] L["Data Options"] = "Data Options"
--[[ enUS ]] L["Data options"] = "Data options"

--[[ enUS ]] L["Load Options"] = "Load Options"
--[[ enUS ]] L["Load options for Aloft modules"] = "Load options for Aloft modules"

--[[ enUS ]] L["Unable to determine module providing data: "] = "Unable to determine module providing data: "
--[[ enUS ]] L["Internal error: Dependency list not resolved - cyclic dependency?"] = "Internal error: Dependency list not resolved - cyclic dependency?"

--[[ enUS ]] L["gui"] = "gui"

-----------------------------------------------------------------------------

local locale = GetLocale()

-----------------------------------------------------------------------------

if (locale == "koKR") then

-----------------------------------------------------------------------------

--[[ koKR ]] L["Aloft"] = "Aloft"
--[[ koKR ]] L["Unknown"] = "Unknown" -- unit name for "Unknown" units

--[[ koKR ]] L["Enable Startup Message"] = "Enable Startup Message"

--[[ koKR ]] L["Nameplate Initialization Interval"] = "Nameplate Initialization Interval"
--[[ koKR ]] L["The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"] = "The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"

--[[ koKR ]] L["Class Colors"] = "Class Colors"
--[[ koKR ]] L["Customize class colors"] = "Customize class colors"
--[[ koKR ]] L["class color"] = "class color"
--[[ koKR ]] L["Reset to Defaults"] = "기본값으로 초기화"
--[[ koKR ]] L["Resets all colors to their defaults"] = "모든 색상을 기본값으로 초기화합니다."

-- labels for keybindings; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ koKR ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ koKR ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ koKR ]] L["Show All Name Plates"] = "Show All Name Plates"

-- player states; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ koKR ]] L["Combat"] = "Combat"
--[[ koKR ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ koKR ]] L["Resting"] = "Resting"
--[[ koKR ]] L["Group"] = "Group"
--[[ koKR ]] L["Default"] = "Default"

-- player locations; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ koKR ]] L["Player Location"] = "Player Location"
--[[ koKR ]] L["World"] = "World"
--[[ koKR ]] L["Battleground"] = "Battleground"
--[[ koKR ]] L["Arena"] = "Arena"
--[[ koKR ]] L["5-Man Instance"] = "5-Man Instance"
--[[ koKR ]] L["Raid Instance"] = "Raid Instance"

--[[ koKR ]] L["Data Options"] = "데이터 설정"
--[[ koKR ]] L["Data options"] = "데이터에 대한 설정입니다."

--[[ koKR ]] L["Load Options"] = "불러오기 설정"
--[[ koKR ]] L["Load options for Aloft modules"] = "Aloft 모듈들에 대한 불러오기 설정입니다."

--[[ koKR ]] L["Unable to determine module providing data: "] = "데이터를 위한 모듈을 결정할 수 없습니다: "
--[[ koKR ]] L["Internal error: Dependency list not resolved - cyclic dependency?"] = "내부적 오류: 목록 의존성이 해결되지 않았습니다 - 순환적인 의존성?"

--[[ koKR ]] L["gui"] = "gui"

-----------------------------------------------------------------------------

elseif (locale == "ruRU") then

-----------------------------------------------------------------------------

--[[ ruRU ]] L["Aloft"] = "Aloft"
--[[ ruRU ]] L["Unknown"] = "Unknown" -- unit name for "Unknown" units

--[[ ruRU ]] L["Enable Startup Message"] = "Enable Startup Message"

--[[ ruRU ]] L["Nameplate Initialization Interval"] = "Nameplate Initialization Interval"
--[[ ruRU ]] L["The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"] = "The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"

--[[ ruRU ]] L["Class Colors"] = "Окраска классов"
--[[ ruRU ]] L["Customize class colors"] = "Настраивать окраски классов"
--[[ ruRU ]] L["class color"] = "class color"
--[[ ruRU ]] L["Reset to Defaults"] = "Сброс в настройки по умолчанию"
--[[ ruRU ]] L["Resets all colors to their defaults"] = "Сбрасывает все цвета в настройки по умолчанию"

-- labels for keybindings; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ ruRU ]] L["Show Neutral/Enemy Name Plates"] = "Отображать таблички нейтральных/враждебных"
--[[ ruRU ]] L["Show Friendly Name Plates"] = "Отображать таблички дружественных"
--[[ ruRU ]] L["Show All Name Plates"] = "Отображать все таблички"

-- player states; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ ruRU ]] L["Combat"] = "Бой"
--[[ ruRU ]] L["Flagged/PvP"] = "Флаг/PvP"
--[[ ruRU ]] L["Resting"] = "Отдых"
--[[ ruRU ]] L["Group"] = "Группа"
--[[ ruRU ]] L["Default"] = "По умолчанию"

-- player locations; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ ruRU ]] L["Player Location"] = "Местонахождение игрока"
--[[ ruRU ]] L["World"] = "Мир"
--[[ ruRU ]] L["Battleground"] = "Поля сражений"
--[[ ruRU ]] L["Arena"] = "Арена"
--[[ ruRU ]] L["5-Man Instance"] = "Инстансы на 5-чел"
--[[ ruRU ]] L["Raid Instance"] = "Рейдовые инстансыe"

--[[ ruRU ]] L["Data Options"] = "Настройка данных"
--[[ ruRU ]] L["Data options"] = "Настройка данных"

--[[ ruRU ]] L["Load Options"] = "Настройки загрузки"
--[[ ruRU ]] L["Load options for Aloft modules"] = "Настройки загрузки для модулей Aloft"

--[[ ruRU ]] L["Unable to determine module providing data: "] = "Невозможно определить модуль, предоставляющий данные"
--[[ ruRU ]] L["Internal error: Dependency list not resolved - cyclic dependency?"] = "Внутренняя ошибка: Невозможно разрешить список зависимостей — циклическая зависимость?"

--[[ ruRU ]] L["gui"] = "gui"

-----------------------------------------------------------------------------

elseif (locale == "zhCN") then

-----------------------------------------------------------------------------

--[[ zhCN ]] L["Aloft"] = "Aloft"
--[[ zhCN ]] L["Unknown"] = "Unknown" -- unit name for "Unknown" units

--[[ zhCN ]] L["Enable Startup Message"] = "Enable Startup Message"

--[[ zhCN  ]] L["Nameplate Initialization Interval"] = "Nameplate Initialization Interval"
--[[ zhCN ]] L["The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"] = "The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"

--[[ zhCN ]] L["Class Colors"] = "职业颜色"
--[[ zhCN ]] L["Customize class colors"] = "自定义职业颜色"
--[[ zhCN ]] L["class color"] = "职业颜色"
--[[ zhCN ]] L["Reset to Defaults"] = "重置为默认"
--[[ zhCN ]] L["Resets all colors to their defaults"] = "将全部颜色设定重置为默认"

-- labels for keybindings; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhCN ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ zhCN ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ zhCN ]] L["Show All Name Plates"] = "Show All Name Plates"

-- player states; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhCN ]] L["Combat"] = "战斗"
--[[ zhCN ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ zhCN ]] L["Resting"] = "休息"
--[[ zhCN ]] L["Group"] = "小队"
--[[ zhCN ]] L["Default"] = "默认"

-- player locations; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhCN ]] L["Player Location"] = "Player Location"
--[[ zhCN ]] L["World"] = "World"
--[[ zhCN ]] L["Battleground"] = "Battleground"
--[[ zhCN ]] L["Arena"] = "Arena"
--[[ zhCN ]] L["5-Man Instance"] = "5-Man Instance"
--[[ zhCN ]] L["Raid Instance"] = "Raid Instance"

--[[ zhCN ]] L["Data Options"] = "数据选项"
--[[ zhCN ]] L["Data options"] = "数据选项"

--[[ zhCN ]] L["Load Options"] = "加载设置"
--[[ zhCN ]] L["Load options for Aloft modules"] = "Aloft模块选项"

--[[ zhCN ]] L["Unable to determine module providing data: "] = "无法确认提供数据的模块"
--[[ zhCN ]] L["Internal error: Dependency list not resolved - cyclic dependency?"] = "内部错误：未找到依赖列表 - 是否遍历依赖？"

--[[ zhCN ]] L["gui"] = "gui"

-----------------------------------------------------------------------------

elseif (locale == "zhTW") then

-----------------------------------------------------------------------------

--[[ zhTW ]] L["Aloft"] = "Aloft"
--[[ zhTW ]] L["Unknown"] = "Unknown" -- unit name for "Unknown" units

--[[ zhTW ]] L["Enable Startup Message"] = "Enable Startup Message"

--[[ zhTW  ]] L["Nameplate Initialization Interval"] = "Nameplate Initialization Interval"
--[[ zhTW ]] L["The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"] = "The amount of time, in seconds, between proactive attempts to detect nameplates that are not yet visible (0.0 is as fast as possible; CAREFUL!)"

--[[ zhTW ]] L["Class Colors"] = "職業顏色"
--[[ zhTW ]] L["Customize class colors"] = "自定義職業顏色"
--[[ zhTW ]] L["class color"] = "職業顏色"
--[[ zhTW ]] L["Reset to Defaults"] = "重設回預設值"
--[[ zhTW ]] L["Resets all colors to their defaults"] = "重設全部顏色回預設值"

-- labels for keybindings; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhTW ]] L["Show Neutral/Enemy Name Plates"] = "Show Neutral/Enemy Name Plates"
--[[ zhTW ]] L["Show Friendly Name Plates"] = "Show Friendly Name Plates"
--[[ zhTW ]] L["Show All Name Plates"] = "Show All Name Plates"

-- player states; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhTW ]] L["Combat"] = "戰斗"
--[[ zhTW ]] L["Flagged/PvP"] = "Flagged/PvP"
--[[ zhTW ]] L["Resting"] = "休息"
--[[ zhTW ]] L["Group"] = "小隊"
--[[ zhTW ]] L["Default"] = "默認"

-- player locations; should match strings in AloftAutoShow/AloftAutoShowOptions.lua and AloftAutoShow localizations
--[[ zhTW ]] L["Player Location"] = "Player Location"
--[[ zhTW ]] L["World"] = "World"
--[[ zhTW ]] L["Battleground"] = "Battleground"
--[[ zhTW ]] L["Arena"] = "Arena"
--[[ zhTW ]] L["5-Man Instance"] = "5-Man Instance"
--[[ zhTW ]] L["Raid Instance"] = "Raid Instance"

--[[ zhTW ]] L["Data Options"] = "資料選項"
--[[ zhTW ]] L["Data options"] = "資料選項"

--[[ zhTW ]] L["Load Options"] = "載入選項"
--[[ zhTW ]] L["Load options for Aloft modules"] = "Aloft 模組的載入選項"

--[[ zhTW ]] L["Unable to determine module providing data: "] = "不能測定模組。資料: "
--[[ zhTW ]] L["Internal error: Dependency list not resolved - cyclic dependency?"] = "內部錯誤: 循環倚靠?"

--[[ zhTW ]] L["gui"] = "gui"

-----------------------------------------------------------------------------

end

-----------------------------------------------------------------------------

AloftLocale.Aloft = setmetatable(L, { __index = function(t, k) rawset(t, k, k) error("Aloft: No translation found for '" .. k .. "'") return k end })
L = nil