--[[
AdiBags - Adirelle's bag addon.
Copyright 2010 Adirelle (adirelle@tagada-team.net)
All rights reserved.
--]]

local addonName, addon = ...

local L = setmetatable({}, {
	__index = function(self, key)
		if key ~= nil then
			--[===[@debug@
			addon:Debug('Missing locale', tostring(key))
			--@end-debug@]===]
			rawset(self, key, tostring(key))
		end
		return tostring(key)
	end,
})
addon.L = L

L["QUIVER_TAG"] = "Qu"
L["AMMO_TAG"] = "Am"
L["SOUL_BAG_TAG"] = "So"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["INSCRIPTION_BAG_TAG"] = "In"
L["HERB_BAG_TAG"] = "He"
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "Eg"
L["KEYRING_TAG"] = "Ke"
L["GEM_BAG_TAG"] = "Ge"
L["MINING_BAG_TAG"] = "Mi"

--------------------------------------------------------------------------------
-- Locales from localization system (not yet)
--------------------------------------------------------------------------------

-- %Localization: adibags
-- THE END OF THE FILE IS UPDATED BY A SCRIPT
-- ANY CHANGE BELOW THESES LINES WILL BE LOST
-- CHANGES SHOULD BE MADE USING http://www.wowace.com/addons/adibags/localization/

-- @noloc[[

------------------------ enUS ------------------------


-- AdiBags.lua
L["AdiBags Anchor"] = true
L["Backpack"] = true
L["Bank"] = true

-- DefaultFilters.lua
L["Ammunition and soul shards"] = true
L["Ammunition"] = true
L["Armor"] = true
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = true
L["Check this so armors are dispatched in four sections by type."] = true
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = true
L["Consider gems as a subcategory of trade goods"] = true
L["Consider glyphs as a subcategory of trade goods"] = true
L["Consumable"] = true
L["Equipment"] = true
L["Four general sections."] = true
L["Gear manager item sets"] = true
L["Gem"] = true
L["Gems are trade goods"] = true
L["Glyph"] = true
L["Glyphs are trade goods"] = true
L["Item category"] = true
L["Jewelry"] = true
L["Junk"] = true
L["Merged sets"] = true
L["Miscellaneous"] = true
L["One section per item slot."] = true
L["One section per set"] = true
L["Only one section."] = true
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = true
L["Put ammunition and soul shards in their own sections."] = true
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = true
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = true
L["Put items in sections depending on their first-level category at the Auction House."] = true
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = true
L["Put quest-related items in their own section."] = true
L["Quest Items"] = true
L["Quest"] = true
L["Recipe"] = true
L["Section setup"] = true
L["Select the sections in which the items should be dispatched."] = true
L["Select which first-level categories should be split by sub-categories."] = true
L["Set: %s"] = true
L["Sets"] = true
L["Soul shards"] = true
L["Split armors by types"] = true
L["Split by subcategories"] = true
L["Trade Goods"] = true
L["Weapon"] = true

-- Options.lua
L["Adjust the maximum height of the bags, relative to screen size."] = true
L["Adjust the maximum number of items per row."] = true
L["Anchored"] = true
L["Background colors"] = true
L["Bag type"] = true
L["Bags"] = true
L["By category, subcategory, quality and item level (default)"] = true
L["By name"] = true
L["By quality and item level"] = true
L["Check this to display a bag type tag in the top left corner of items."] = true
L["Check this to display a colored border around items, based on item quality."] = true
L["Check this to display an indicator on quest items."] = true
L["Check this to have poor quality items dimmed."] = true
L["Check to enable this module."] = true
L["Click there to reset the bag positions and sizes."] = true
L["Click to toggle the bag anchor."] = true
L["Configure"] = true
L["Dim junk"] = true
L["Enabled"] = true
L["Fill lines at most"] = true
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = true
L["Filters"] = true
L["Free space"] = true
L["Group sections of same category"] = true
L["Incomplete stacks"] = true
L["Items"] = true
L["Layout priority"] = true
L["Lock anchor"] = true
L["Manual"] = true
L["Maximum bag height"] = true
L["Maximum row width"] = true
L["Opacity"] = true
L["Other items"] = true
L["Plugins"] = true
L["Position mode"] = true
L["Priority"] = true
L["Quality highlight"] = true
L["Quest indicator"] = true
L["Reset position"] = true
L["Scale"] = true
L["Select how items should be sorted within each section."] = true
L["Select how the bag are positionned."] = true
L["Sorting order"] = true
L["Stackable items"] = true
L["Strictly keep ordering"] = true
L["Toggle and configure item filters."] = true
L["Toggle and configure plugins."] = true
L["Uncheck this to disable AdiBags."] = true
L["Unlock anchor"] = true
L["Use this to adjust the bag scale."] = true
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = true
L["Virtual stacks display in one place items that actually spread over several bag slots."] = true
L["Virtual stacks"] = true

-- modules/CurrencyFrame.lua
L["Currency"] = true
L["Display character currency at bottom left of the backpack."] = true

-- modules/DataSource.lua
L["Bag usage format"] = true
L["Check this to display an icon after usage of each type of bags."] = true
L["Check this to display an textual tag before usage of each type of bags."] = true
L["Check this to display only one value counting all equipped bags, ignoring their type."] = true
L["Check this to show space at your bank in the plugin."] = true
L["Free space / total space"] = true
L["LDB Plugin"] = true
L["Merge bag types"] = true
L["Provides a LDB data source to be displayed by LDB display addons."] = true
L["Select how bag usage should be formatted in the plugin."] = true
L["Show bag type icons"] = true
L["Show bag type tags"] = true
L["Show bank usage"] = true
L["Space in use / total space"] = true
L["Space in use"] = true

-- modules/FilterOverride.lua
L["Add association"] = true
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = true
L["Are you sure you want to remove this association ?"] = true
L["Click on this button to create the new association."] = true
L["Drop your item there to add it to this section."] = true
L["Enter the name of the section to associate with the item."] = true
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = true
L["Item"] = true
L["Manual filtering"] = true
L["New Override"] = true
L["Section category"] = true
L["Section"] = true
L["Select the category of the section to associate. This is used to group sections together."] = true
L["Use this section to define any item-section association."] = true

-- modules/MoneyFrame.lua
L["Display character money at bottom right of the backpack."] = true
L["Money"] = true

-- modules/NewItemTracking.lua
L["Click to reset item status."] = true
L["Highlight color"] = true
L["Highlight scale"] = true
L["New item highlight"] = true
L["New"] = true
L["Reset new items"] = true
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = true
L["Track new items"] = true

-- modules/SearchHighlight.lua
L["Enter a text to search in item names."] = true
L["Item search"] = true
L["Provides a text widget at top of the backpack where you can type (part of) an item name to locate it in your bags."] = true
L["Search:"] = true

-- modules/TidyBags.lua
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = true
L["Click to tidy bags."] = true
L["Semi-automated tidy"] = true
L["Tidy bags"] = true
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = true

-- modules/TooltipInfo.lua
L["AH category"] = true
L["AH subcategory"] = true
L["Add more information in tooltips related to items in your bags."] = true
L["Always"] = true
L["Bag number"] = true
L["Category"] = true
L["Container information"] = true
L["Filter"] = true
L["Filtering information"] = true
L["Item information"] = true
L["Maximum stack size"] = true
L["Never"] = true
L["Show container information..."] = true
L["Show filtering information..."] = true
L["Show item information..."] = true
L["Slot number"] = true
L["Tooltip information"] = true
L["When alt is held down"] = true
L["When any modifier key is held down"] = true
L["When ctrl is held down"] = true
L["When shift is held down"] = true

-- widgets/BagSlots.lua
L["Click to purchase"] = true
L["Equipped bags"] = true

-- widgets/ContainerFrame.lua
L["Buggy items"] = true
L["Check this to show this section. Uncheck to hide it."] = true
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = true
L["Click to toggle the equipped bag panel, so you can change them."] = true
L["Close"] = true
L["Section visibility"] = true
L["Show %s"] = true


------------------------ frFR ------------------------
local locale = GetLocale()
if locale == 'frFR' then
L["Add association"] = "Ajouter l'association"
L["Add more information in tooltips related to items in your bags."] = "Ajoute des informations additionnelles dans les bulles d'aides des objets de vos sacs."
L["AdiBags Anchor"] = "Ancre d'AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajustez la taille maximale des sacs, par rapport à la taille de l'écran."
L["Adjust the maximum number of items per row."] = "Ajustez le nombre maximale d'objets par ligne."
L["AH category"] = "Catégorie HV"
L["AH subcategory"] = "Sous-catégorie HV"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Vous permet de redéfinir manuellement la section dans laquelle un objet doit être mis. Tirez simplement un objet sur le titre de section."
L["Always"] = "Toujours"
L["AMMO_TAG"] = "Ba"
L["Ammunition"] = "Munitions"
L["Ammunition and soul shards"] = "Munitions et fragments d'âme."
L["Anchored"] = "Ancrée"
L["Are you sure you want to remove this association ?"] = "Etes-vous sûr de vouloir supprimer cette association ?"
L["Armor"] = "Armure"
L["Background colors"] = "Couleurs de fond"
L["Backpack"] = "Sac à dos"
L["Bag number"] = "Numéro du sac"
L["Bags"] = "Sacs"
L["Bag type"] = "Type de sac"
L["Bag usage format"] = "Format de l'usage des sacs"
L["Bank"] = "Banque"
L["Buggy items"] = "Objets buggés"
L["By category, subcategory, quality and item level (default)"] = "Par catégorie, sous-catégorie, qualité et niveau d'objet (par défaut)"
L["By name"] = "Par nom"
L["By quality and item level"] = "Par qualité et niveau d'objet"
L["Category"] = "Catégorie"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Cochez les ensembles qui doivent être fusionnés en une section \"Ensembles\" unique. C'est évident un réglage spécifique à ce personnage."
L["Check this so armors are dispatched in four sections by type."] = "Cochez ceci pour que les armures sont distribuées dans quatre sections selon leur type."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Cochez ceci afin que les sacs soient rangés automatiquement quand vous fermez la fenêtre de butin ou de boîte aux lettres ou que vous quittez les marchands,"
L["Check this to display a bag type tag in the top left corner of items."] = "Cochez ceci pour afficher le type des sacs dans le coin supérieur gauche des objets."
L["Check this to display a colored border around items, based on item quality."] = "Cochez ceci pour afficher un bord coloré autour des objets basé sur leur qualité."
L["Check this to display an icon after usage of each type of bags."] = "Cochez ceci pour afficher une icône de type de sac après l'usage."
L["Check this to display an indicator on quest items."] = "Cochez ceci pour afficher un indicateur sur les objets de quête."
L["Check this to display an textual tag before usage of each type of bags."] = "Cochez ceci pour afficher le type de sac avant l'usage."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Cochez ceci pour afficher une section individuel par ensemble d'équipement. Sinon, il n'y aura qu'une seule section \"Ensembles\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Cochez ceci pour n'afficher qu'une seule valeur pour tous les sacs, quelque soit leur type."
L["Check this to have poor quality items dimmed."] = "Ciochez ceci pour assombrir les objets de mauvaise qualité."
L["Check this to show space at your bank in the plugin."] = "Cochez ceci pour afficher l'espace libre de votre banque."
L["Check to enable this module."] = "Cochez cette case pour activer ce module."
L["Click on this button to create the new association."] = "Cliquez sur ce bouton pour créer la nouvelle association."
L["Click there to reset the bag positions and sizes."] = "Cliquez ici pour remettre à zéro la position et la taille de sacs."
L["Click to purchase"] = "Cliquez pour acheter."
L["Click to reset item status."] = "Cliquez pour remettre à zéro les nouveaux objets."
L["Click to tidy bags."] = "Cliquez pour ranger les sacs."
L["Click to toggle the bag anchor."] = "Cliquez pour afficher/cacher l'ancre des sacs."
L["Click to toggle the equipped bag panel, so you can change them."] = "Cliquez pour afficher/cacher le panneau des sacs équipés. Vous pourrez ainsi les manipuler."
L["Close"] = "Fermer"
L["Configure"] = "Configurer"
L["Consider gems as a subcategory of trade goods"] = "Considère les gemmes comme une sous-catégorie d'artisanat."
L["Consider glyphs as a subcategory of trade goods"] = "Considère les glyphes comme une sous-catégorie d'artisanat."
L["Consumable"] = "Consommable"
L["Container information"] = [=[Information sur le contenant
]=]
L["Currency"] = "Insignes"
L["Dim junk"] = "Assombrir la camelote"
L["Display character currency at bottom left of the backpack."] = "Affiche les insignes du personnage en bas à gauche du sac à dos."
L["Display character money at bottom right of the backpack."] = "Affiche l'or du personnage en bas à droite du sac à dos."
L["Drop your item there to add it to this section."] = "Déposez votre objet ici pour l'ajouter à cette section."
L["Enabled"] = "Activé"
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "In"
L["Enter a text to search in item names."] = "Saisissez un texte pour faire une recherche sur les noms d'objets."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Entrez le nom, le lien ou l'identifiant de l'objet à associer à la section. Vous pouvez aussi déposer un objet dans cette boîte."
L["Enter the name of the section to associate with the item."] = "Entrez le nom de la section à associer à l'objet."
L["Equipment"] = "Equipement"
L["Equipped bags"] = "Sacs équipés"
L["Fill lines at most"] = "Remplir les lignes au maximum"
L["Filter"] = "Filtre"
L["Filtering information"] = "Information de filtrage"
L["Filters"] = "Filtres"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Les filtres sont utilisés pour répartir les objets en section de sac. Un objet ne peut apparaître que dans une seule section. Si un objet correspond à plusieurs filtres, celui avec la meilleur priorité l'emporte."
L["Four general sections."] = "Quatre sections générales."
L["Free space"] = "Espace libre"
L["Free space / total space"] = "Espace libre / espace total"
L["Gear manager item sets"] = "Ensembles d'objets du gestionnaire d'équipement"
L["Gem"] = "Gemme"
L["GEM_BAG_TAG"] = "Jo"
L["Gems are trade goods"] = "Gemmes dans artisanat"
L["Glyph"] = "Glyphe"
L["Glyphs are trade goods"] = "Glyphes dans artisanat"
L["Group sections of same category"] = "Grouper les sections de la même catégorie"
L["HERB_BAG_TAG"] = "He"
L["Highlight color"] = "Couleur du surlignage"
L["Highlight scale"] = "Echelle du surlignage"
L["Incomplete stacks"] = "Piles incomplètes"
L["INSCRIPTION_BAG_TAG"] = "Ca"
L["Item"] = "Objet"
L["Item category"] = "Catégories d'objets"
L["Item information"] = "Informations sur l'objet"
L["Items"] = "Objets"
L["Item search"] = "Recherche d'objet"
L["Jewelry"] = "Joaillerie"
L["Junk"] = "Camelote"
L["KEYRING_TAG"] = "Cl"
L["Layout priority"] = "Priorité de disposition"
L["LDB Plugin"] = "Plugin LDB"
L["LEATHERWORKING_BAG_TAG"] = "Cu"
L["Lock anchor"] = "Verrouiller l'ancre"
L["Manual"] = "Manuelle"
L["Manual filtering"] = "Filtrage manuel"
L["Maximum bag height"] = "Hauteur maximale des sacs"
L["Maximum row width"] = "Largeur maximale des lignes"
L["Maximum stack size"] = "Taille maximale des piles"
L["Merge bag types"] = "Fusionner les types de sacs"
L["Merged sets"] = "Ensembles fusionnés"
L["MINING_BAG_TAG"] = "Mi"
L["Miscellaneous"] = "Divers"
L["Money"] = "Monnaie"
L["Never"] = "Jamais"
L["New"] = "Nouveau"
L["New item highlight"] = "Surlignage des nouveaux objets"
L["New Override"] = "Nouvelle association"
L["One section per item slot."] = "Une section par emplacement d'équipement"
L["One section per set"] = "Une section par ensemble"
L["Only one section."] = "Seulement une section"
L["Opacity"] = "Opacité"
L["Other items"] = "Autres objets"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Veuillez notez que ce filtre correspond à tous les objets. Tout filtre avec une priorité plus faible que celle de ce filtre n'aura aucun effet."
L["Plugins"] = "Plugins"
L["Position mode"] = "Disposition"
L["Priority"] = "Priorité"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Fournit une source LDB qui peut être affichée dans un addon d'affichage de LDB."
L["Provides a text widget at top of the backpack where you can type (part of) an item name to locate it in your bags."] = "Ajoute une zone de texte en haut du sac à dos, dans laquelle vous pouvez taper le nom (même partiel) d'un objet pour le retrouver dans vos sacs."
L["Put ammunition and soul shards in their own sections."] = "Place les munitions et les fragments d'âmes dans des sections spécifiques."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Place les objets qui peuvent être équipés (y compris les sacs) dans la section \"Equipement\"."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Place les objets appartenant à un ou plusieurs ensembles d'objet du gestionnaire d'objets dans des sections spécifiques."
L["Put items in sections depending on their first-level category at the Auction House."] = "Répartit les objets en fonction de leur catégorie principale (premier niveau de l'Hôtel des Ventes). "
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Place les objets de mauvaise qualité ou considéré comme camelote dans la section \"Camelote\"."
L["Put quest-related items in their own section."] = "Place les objets en rapport avec les quêtes dans une section spécifique."
L["Quality highlight"] = "Surlignage de la qualité"
L["Quest"] = "Quête"
L["Quest indicator"] = "Indicateur de quête"
L["Quest Items"] = "Objets de quête"
L["QUIVER_TAG"] = "Fl"
L["Recipe"] = "Recette"
L["Reset new items"] = "Remet à zéro les nouveaux objets."
L["Reset position"] = "R.à.z. position"
L["Scale"] = "Echelle"
L["Search:"] = "Recherche :"
L["Section"] = "Section"
L["Section category"] = "Catégorie de section"
L["Section setup"] = "Configuration de section"
L["Select how bag usage should be formatted in the plugin."] = "Choisissez comment l'occupation d'un sac doit être formaté."
L["Select how items should be sorted within each section."] = "Choisissez comment les objets doivent être triés à l'intérieur de chaque section."
L["Select how the bag are positionned."] = "Sélectionnez la façon dont les sacs sont disposés."
L["Select the category of the section to associate. This is used to group sections together."] = "Sélectionnez la catégorie de la section à associer. Ceci est utilisé pour regrouper les sections."
L["Select the sections in which the items should be dispatched."] = "Sélectionnez les sections parmi lesquelles l'objet devra être affiché"
L["Select which first-level categories should be split by sub-categories."] = "Sélectionnez quelles catégories doivent être séparée en sous-catégories."
L["Semi-automated tidy"] = "Rangement semi-automatique"
L["Sets"] = "Ensembles"
L["Set: %s"] = "Ens.: %s"
L["Show bag type icons"] = "Affiche les icônes de type de sacs"
L["Show bag type tags"] = "Affiche les tags de type de sac"
L["Show bank usage"] = "Afficher la banque"
L["Show container information..."] = "Afficher les informations du contenant..."
L["Show filtering information..."] = "Afficher les informations de flitrage..."
L["Show item information..."] = "Afficher les informations sur l'objet..."
L["Slot number"] = "Numéro d'emplacement"
L["Sorting order"] = "Ordre de tri"
L["SOUL_BAG_TAG"] = "Âm"
L["Soul shards"] = "Fragments d'âme"
L["Space in use"] = "Espace utilisé"
L["Space in use / total space"] = "Espace utilisé / espace total"
L["Split armors by types"] = "Séparer les types d'armures"
L["Split by subcategories"] = "Répartir par sous-catégorie"
L["Stackable items"] = "Objets empilables"
L["Strictly keep ordering"] = "Conserver strictement l'ordre"
L["Tidy bags"] = "Ranger les sacs"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Range vos sacs lorsque vous cliquez sur le bouton \"T\" en haut à droite des sacs. Dans la mesure du possible, les sacs spéciaux seront remplis avec les objets correspondant, et les objets seront empilés pour libérer de la place."
L["Toggle and configure item filters."] = "Activer et configurer les filtres."
L["Toggle and configure plugins."] = "Activer et configurer les plugins."
L["Tooltip information"] = "Informations dans les bulles d'aides"
L["Track new items"] = "Détection des nouveaux objets"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Détecte les nouveaux objets dans chaque sac, affiche une lueur colorée auteur d'eux et les place dans une section spéciale. Les nouveaux objets peuvent être remis à zéro en cliquant sur le bouton \"N\" en haut à droite des sacs."
L["Trade Goods"] = "Artisanat"
L["Uncheck this to disable AdiBags."] = "Décochez ceci pour désactiver AdiBags."
L["Unlock anchor"] = "Déverrouiler l'ancre"
L["Use this section to define any item-section association."] = "Utilisez cette section pour définir de nouvelles associations objet-section."
L["Use this to adjust the bag scale."] = "Ajustez la taille des sacs."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Ajustez l'opacité de la bordure de qualité. 100% signifie complétement opaque."
L["Virtual stacks"] = "Piles virtuelles"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Les piles virtuelles affichent en un seul endroit plusieurs piles d'objets."
L["Weapon"] = "Arme"
L["When alt is held down"] = "Quand ALT est enfoncé"
L["When any modifier key is held down"] = "Quand n'importe quelle touche de modification est enfoncée"
L["When ctrl is held down"] = "Quand CONTROL est enfoncé"
L["When shift is held down"] = "Quand MAJ est enfoncé"

------------------------ deDE ------------------------
elseif locale == 'deDE' then
L["Add association"] = "Füge Zuweisung hinzu"
L["Add more information in tooltips related to items in your bags."] = "Füge mehr Informationen bezüglich der Items in deinen Taschen zum Tooltip hinzu"
L["AdiBags Anchor"] = "AdiBags Anker"
L["Adjust the maximum height of the bags, relative to screen size."] = "Passt die maximale Höhe der Taschen in Relation zur Monitorauflösung an."
L["Adjust the maximum number of items per row."] = "Passt die maximale Anzahl von Gegenständen pro Reihe an"
L["AH category"] = "AH Kategorie"
L["AH subcategory"] = "AH Unterkategorie"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Erlaubt eine manuelle Neudefinierung eines Bereiches, in dem ein Gegenstand abegelegt werden soll. Ziehe den Gegenstand einfach auf die Sektionsleiste."
L["Always"] = "Immer"
L["AMMO_TAG"] = "Mu"
L["Ammunition"] = "Munition"
L["Ammunition and soul shards"] = "Munition und Seelensplitter"
L["Anchored"] = "Verankert" -- Needs review
L["Are you sure you want to remove this association ?"] = "Möchtest du diese Zuweisung wirklich löschen?"
L["Armor"] = "Rüstung"
L["Background colors"] = "Hintergrundfarben"
L["Backpack"] = "Rucksack"
L["Bag number"] = "Taschennummer"
L["Bags"] = "Taschen"
L["Bag type"] = "Taschenart"
L["Bag usage format"] = "Format der Taschennutzung"
L["Bank"] = "Bank"
L["Buggy items"] = "fehlerhafte Gegenstände" -- Needs review
L["By category, subcategory, quality and item level (default)"] = "Nach Kategorie, Unterkategorie, Qualität und iLvl. (Standard)"
L["By name"] = "Nach Name"
L["By quality and item level"] = "Nach Qualität und iLvl"
L["Category"] = "Kategorie"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Aktiviere Sets die in einem einzigartigen Set-Bereich zusammengeführt werden sollen. Das ist offensichtlich eine Einstellung für jeden Charakter."
L["Check this so armors are dispatched in four sections by type."] = "Markieren damit die Rüstungen in vier Typen eingeteilt wird."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Überprüfen Sie ob das Aufräumen durchgeführt wurde, wenn Sie daß Beute-Fenster schließen oder Sie Händler, Briefkästen usw verlassen." -- Needs review
L["Check this to display a bag type tag in the top left corner of items."] = "Aktivieren um die Taschenart in der oberen linken Ecke eines Gegenstandes anzuzeigen"
L["Check this to display a colored border around items, based on item quality."] = "Aktivieren um den Rahmen um den Gegenstand in der Farbe seiner Qualität anzuzeigen."
L["Check this to display an icon after usage of each type of bags."] = "Aktivieren um ein icon nach der Benutzung jeglicher Art von Taschen anzuzeigen"
L["Check this to display an indicator on quest items."] = "Aktivieren um Questgegenstände mit einem farblichen Rahmen hervorzuheben."
L["Check this to display an textual tag before usage of each type of bags."] = "Aktivieren um einen Bezeichnung vor der Benutzung eines jeden Taschentyps anzeigen zu lassen"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Aktivieren um einen individuellen Bereich pro Set anzuzeigen. Wenn das hier nicht aktiviert ist wird nur ein großer \"Set\" Bereich angezeigt."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Aktivieren um nur einen Wert anzuzeigen der alle belegten Taschenplätze zählt. Die Art der Tasche wird ignoriert."
L["Check this to have poor quality items dimmed."] = "Aktivieren um Gegenstände mit geringer Qualität dunkler darzustellen"
L["Check this to show space at your bank in the plugin."] = "Aktivieren um den freien Platz der Bank im Plugin anzuzeigen."
L["Check to enable this module."] = "Aktivieren um dieses Modul zu nutzen."
L["Click on this button to create the new association."] = "Klicke auf diesen Knopf um eine neue Zuweisung zu erstellen"
L["Click there to reset the bag positions and sizes."] = "Hier klicken zum Zurücksetzen der Taschenposition und Größe."
L["Click to purchase"] = "Anklicken zum kaufen"
L["Click to reset item status."] = "Klicken um den Gegenstandsstatus zurückzusetzen."
L["Click to tidy bags."] = "Klicken um die Taschen aufzuräumen"
L["Click to toggle the bag anchor."] = "Klicken um den Taschenanker anzuzeigen"
L["Click to toggle the equipped bag panel, so you can change them."] = "Klicken um die Taschenleiste anzuzeigen. Die Taschen können somit getauscht/belegt werden."
L["Close"] = "Schließen"
L["Configure"] = "Konfigurieren"
L["Consider gems as a subcategory of trade goods"] = "Edelsteine als Unterkategorie von handelbaren Gegenständen betrachten"
L["Consider glyphs as a subcategory of trade goods"] = "Glyphen als Unterkategorie von handelbaren Gegenständen betrachten"
L["Consumable"] = "Verbrauchbar"
L["Container information"] = "Behälterinformation"
L["Currency"] = "Embleme"
L["Dim junk"] = "Graue Gegenstände verblassen."
L["Display character currency at bottom left of the backpack."] = "Zeigt die Embleme des Charakters rechts unten beim Rucksack an"
L["Display character money at bottom right of the backpack."] = "Zeigt das Gold des Charakters rechts unten beim Rucksack an"
L["Drop your item there to add it to this section."] = "item hier hin ziehen um es dieser Sektion hinzuzufügen"
L["Enabled"] = "aktiviert"
L["ENCHANTING_BAG_TAG"] = "Vz"
L["ENGINEERING_BAG_TAG"] = "Ing"
L["Enter a text to search in item names."] = "Text eingeben um nach Gegenständen zu suchen"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Gib den Namen, den Link oder die ItemId des Gegenstandes ein, der dem Bereich zugewiesen werden soll. Du kannst auch einen Gegenstand in dieses Feld ziehen."
L["Enter the name of the section to associate with the item."] = "Gib den Namen des Bereiches ein, der dem Gegenstand zugewiesen werden soll"
L["Equipment"] = "Ausrüstung"
L["Equipped bags"] = "Angelegte Taschen."
L["Fill lines at most"] = "Fülle die Reihen bis Maximum"
L["Filter"] = "Filter"
L["Filtering information"] = "Filterinformationen"
L["Filters"] = "Filter"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Filter werden benutzt um Gegenstände in Taschenabteilungen zu befördern. Ein Gegenstand kann immer nur in einer Abteilung auftauchen. Wenn für den Gegenstand mehrere Filter zutreffen dann wird der Filter mit der höchsten Priorität genommen."
L["Four general sections."] = "Vier Hauptbereiche"
L["Free space"] = "freier Platz"
L["Free space / total space"] = "freier Platz / gesamter Platz"
L["Gear manager item sets"] = "Sets vom Ausrüstungsmanager"
L["Gem"] = "Edelstein"
L["GEM_BAG_TAG"] = "Ju"
L["Gems are trade goods"] = "Edelsteine sind handelbare Gegenstände"
L["Glyph"] = "Glyphe"
L["Glyphs are trade goods"] = "Glyphen sind handelbare Gegenstände"
L["Group sections of same category"] = "Gruppenabteilungen der selben Kategorie"
L["HERB_BAG_TAG"] = "Kr"
L["Highlight color"] = "Farbe hervorheben"
L["Highlight scale"] = "Skalierung für die Hervorhebung"
L["Incomplete stacks"] = "unvollständige Stapel"
L["INSCRIPTION_BAG_TAG"] = "In"
L["Item"] = "Gegenstand"
L["Item category"] = "Kategorie für Gegenstände"
L["Item information"] = "Gegenstandsinformation"
L["Items"] = "Gegenstände"
L["Item search"] = "Suche nach Gegenständen"
L["Jewelry"] = "Juwelier"
L["Junk"] = "Plunder"
L["KEYRING_TAG"] = "Schl"
L["Layout priority"] = "Darstellung Vorrang"
L["LDB Plugin"] = "LBD Plugin"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["Lock anchor"] = "Anker abschließen"
L["Manual"] = "Verschiebbar" -- Needs review
L["Manual filtering"] = "Selbst einstellbare Filter"
L["Maximum bag height"] = "maximale Taschenhöhe"
L["Maximum row width"] = "maximale Breite für die Reihe"
L["Maximum stack size"] = "Maximale Stapelgröße"
L["Merge bag types"] = "Taschenarten mischen"
L["Merged sets"] = "Sets mischen"
L["MINING_BAG_TAG"] = "Bb"
L["Miscellaneous"] = "Verschiedenes"
L["Money"] = "Geld"
L["Never"] = "Niemals"
L["New"] = "Neu"
L["New item highlight"] = "Neue Gegenstände hervorheben"
L["New Override"] = "Neue Aufhebung"
L["One section per item slot."] = "Eine Bereich pro Gegenstandsplatz"
L["One section per set"] = "Eine Abteilung pro Set"
L["Only one section."] = "Nur ein Bereich"
L["Opacity"] = "Durchsichtigkeit"
L["Other items"] = "Andere Gegenstände"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Bitte beachten: dieser Filter bezieht sich auf jeden Gegenstand. Alle Filter mit niedriger Priorität als dieser wird keinen Effekt haben."
L["Plugins"] = "Plugins"
L["Position mode"] = "Positions Modus" -- Needs review
L["Priority"] = "Priorität"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Sieht vor, dass eine LDB Datenquelle von DataBroker Addons angezeigt wird"
L["Provides a text widget at top of the backpack where you can type (part of) an item name to locate it in your bags."] = "Stellt ein Eingabefeld über der Taschenleiste zur Verfügung um einen Namen (oder Teile des Namens) eines Gegenstandes einzugeben um diesen in den Taschen zu finden."
L["Put ammunition and soul shards in their own sections."] = "Zeigt Munition und Seelensplitter in eigenen Bereichen an."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Zeigt jeden verwendbaren Gegenstand (inklusive Taschen) im \"Equipment\" Bereich."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Zeigt Gegenstände die zu einem oder mehreren Sets des Ausrüstungsmanagers gehören in eigenen Bereichen an."
L["Put items in sections depending on their first-level category at the Auction House."] = "Zeigt Gegenstände basierend auf der ersten Kategorie des Auktoinshauses in den Bereichen an"
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Zeigt Gegenstände geringer Qualität oder als Müll gekennzeichnete Gegenstände im \"Junk\" Bereich an."
L["Put quest-related items in their own section."] = "Zeigt questbezogene Gegenstände in einem eigenen Bereich an"
L["Quality highlight"] = "Qualität hervorheben"
L["Quest"] = "Quest"
L["Quest indicator"] = "Quest Kennzeichen"
L["Quest Items"] = "Questgegenstand"
L["QUIVER_TAG"] = "Kö"
L["Recipe"] = "Rezept"
L["Reset new items"] = "Neue Gegenstände zurücksetzen"
L["Reset position"] = "Position zurücksetzen"
L["Scale"] = "Skalierung"
L["Search:"] = "Suche:"
L["Section"] = "Bereich"
L["Section category"] = "Bereichskategorie"
L["Section setup"] = "Bereichssetup"
L["Select how bag usage should be formatted in the plugin."] = "Wähle aus, wie die Taschennutzung im Plugin formatiert werden soll"
L["Select how items should be sorted within each section."] = "Wähle aus, wie die Gegenstände in jedem Bereich einsortiert werden sollen"
L["Select how the bag are positionned."] = "Auswählen um zu zeigen wie die Taschen positioniert werden."
L["Select the category of the section to associate. This is used to group sections together."] = "Wähle die Kategorie aus, die dem Bereich zugewiesen werden soll. Damit werden Bereiche zusammen angeordnet "
L["Select the sections in which the items should be dispatched."] = "Wähle den Bereich aus, in welchem die Gegenstände abgelegt werden sollen"
L["Select which first-level categories should be split by sub-categories."] = "Wähle aus, welche Oberkategorien von Unterkategorien aufgeteilt werden sollen"
L["Sets"] = "Sets"
L["Set: %s"] = "Set: %s"
L["Show bag type icons"] = "Zeige die Art der Taschen als Icon an"
L["Show bag type tags"] = "Zeige die Art der Taschen als Text an"
L["Show bank usage"] = "Zeige die Bank Nutzung an"
L["Show container information..."] = "Zeige Behälterinformation"
L["Show filtering information..."] = "Zeige Filterinformationen"
L["Show item information..."] = "Zeige Gegenstandsinformation"
L["Slot number"] = "Platznummer"
L["Sorting order"] = "Sortierreihenfolge"
L["SOUL_BAG_TAG"] = "Se"
L["Soul shards"] = "Seelensplitter"
L["Space in use"] = "Belegte Plätze"
L["Space in use / total space"] = "Belegte Plätze / alle Plätze"
L["Split armors by types"] = "Rüstung nach Typ"
L["Split by subcategories"] = "Aufteilen nach Unterkategorieen"
L["Stackable items"] = "stapelbare Gegenstände"
L["Strictly keep ordering"] = "Genaue Reihenfolge einhalten"
L["Tidy bags"] = "Taschen aufräumen"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Um deine Taschen aufzuräumen klicke auf den kleinen \"T\" Knopf oben links. Spezielle Taschen mit freien Plätzen werden dann mit passenden Gegenständen gefüllt und stapelbare Gegenstände werden gestapelt um Platz zu sparen."
L["Toggle and configure item filters."] = "Gegenstandsfilter aktivieren und konfigurieren"
L["Toggle and configure plugins."] = "Plugins aktivieren und konfigurieren"
L["Tooltip information"] = "Tooltipinformation"
L["Track new items"] = "Neue Gegenstände beobachten"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Beobachtete Gegenstände in jeder Tasche mit einer glühenden Aura versehen und in eine spezielle Abteilung verschieben. Der \"New\" Status kann durch klicken auf den kleinen \"N\" Knopf oben links bei den Tachen zurückgesetzt werden."
L["Trade Goods"] = "Handwerkswaren"
L["Uncheck this to disable AdiBags."] = "Unmarkieren um Adibags zu deaktivieren."
L["Unlock anchor"] = "Anker aufschliessen"
L["Use this section to define any item-section association."] = "Benutze diesen Bereich, um eine beliebige Gegenstand-Sektionen-Zuweisung zu definieren"
L["Use this to adjust the bag scale."] = "Skalierung der Taschen anpassen"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Deckkraft der Umrandung für die Qualität der Gegenstände anpassen. 100% bedeutet volle Deckkraft"
L["Virtual stacks"] = "virtuelle Stapel"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Virtuelle Stapelanzeige von Gegenstäden, die in verschiedenen Taschen verteilt sind, an einer Stelle"
L["Weapon"] = "Waffe"
L["When alt is held down"] = "Wenn Alt gedrückt ist"
L["When any modifier key is held down"] = "Wenn irgendeine Modifizierungstase gedrückt ist"
L["When ctrl is held down"] = "Wenn Strg gedrückt ist"
L["When shift is held down"] = "Wenn Umschalt gedrückt ist"

------------------------ esMX ------------------------
-- no translation

------------------------ ruRU ------------------------
elseif locale == 'ruRU' then
L["Add association"] = "Добавить объединение"
L["Add more information in tooltips related to items in your bags."] = "Добавить Дополнительную информацию во всплывающих подсказках, касающихся предметов, в вашей сумке"
L["AdiBags Anchor"] = "AdiBags Якорь"
L["Adjust the maximum height of the bags, relative to screen size."] = "Регулировка максимальной высоты сумок, относительно размеру экрана."
L["Adjust the maximum number of items per row."] = "регулировка максимально количества предметов в ряду."
L["AH category"] = "Категория аукциона"
L["AH subcategory"] = "Подкатегория аукциона"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Позволяет вручную изменять секцию в которую следует переместить предмет. Просто перетащите элемент за название раздела."
L["Always"] = "Всегда"
L["AMMO_TAG"] = "Бп"
L["Ammunition"] = "Боеприпасы"
L["Ammunition and soul shards"] = "Боеприпасы и камни душ"
L["Anchored"] = "Закрепленные"
L["Are you sure you want to remove this association ?"] = "Вы уверены что хотите удалить ассоциаци ?"
L["Armor"] = "Доспехи"
L["Background colors"] = "Цвета фона"
L["Backpack"] = "Рюкзак"
L["Bag number"] = "Номер сумки"
L["Bags"] = "Сумки"
L["Bag type"] = "Тип сумки"
L["Bag usage format"] = "Формат использования сумки"
L["Bank"] = "Банк"
L["Buggy items"] = "багнутые предметы"
L["By category, subcategory, quality and item level (default)"] = "По категории, под-гатекогии, качеству и уровню предмета (по умолчанию)"
L["By name"] = "По имени"
L["By quality and item level"] = "По качеству и уровню"
L["Check this to display a bag type tag in the top left corner of items."] = "Поставте галочку, чтобы отображать тег сумки в левом верхнем углу иконки предмета."
L["Check this to display a colored border around items, based on item quality."] = "Поставьте галочка, чтобы окрашивать края предметов основываясь на их качество."
L["Check this to display an icon after usage of each type of bags."] = "Поставте тут галочку для отображения иконки после использования каждого вида сумки."
L["Check this to display an indicator on quest items."] = "Поставте тут галочку чтобы отображать индикатор на предметах, необходимых для задания."
L["Check this to have poor quality items dimmed."] = "Поставьте галочку, для отабражения низкова уровня вешей затемнёным цветом."
L["Check to enable this module."] = "Поставте галочку для включения данного модуля."
L["Click there to reset the bag positions and sizes."] = "Кликните тут чтобы сбросить расположение сумок и размер."
L["Click to purchase"] = "Кликните чтобы купить"
L["Click to reset item status."] = "Кликните чтобы сбросить статус предмета."
L["Click to toggle the bag anchor."] = "Кликните чтобы переключить якорь сумки."
L["Click to toggle the equipped bag panel, so you can change them."] = "Кликните для переключения панели надетых сумок, так что вы можете их изменить."
L["Close"] = "Закрыть"
L["Configure"] = "Настройка"
L["Consider gems as a subcategory of trade goods"] = "Рассматривать самоцветы как подкатегорию хозяйственных товаров"
L["Consider glyphs as a subcategory of trade goods"] = "Рассматривать символы как подкатегорию хозяйственных товаров"
L["Consumable"] = "Расходуемые"
L["Dim junk"] = "Затемнять хлам"
L["Display character money at bottom right of the backpack."] = "Отображать деньги персонажа в нижнем правом углу рюкзака."
L["Drop your item there to add it to this section."] = "Чтобы добавить предмет в этот раздел, переместите его туда. "
L["Enabled"] = "Включен"
L["ENCHANTING_BAG_TAG"] = "Чры"
L["ENGINEERING_BAG_TAG"] = "Эн"
L["Enter a text to search in item names."] = "Введите текст для поиска предмета по названию."
L["Equipment"] = "Экипировка"
L["Equipped bags"] = "Сукмки у персонажа"
L["Filters"] = "Фильтры"
L["Free space"] = "Свободно"
L["Free space / total space"] = "Свободно / всего места"
L["Gear manager item sets"] = "Предметы наборов управления экипировкой"
L["Gem"] = "Самоцветы"
L["GEM_BAG_TAG"] = "См"
L["Gems are trade goods"] = "Самоцветы это Хозяйственные товары"
L["Glyph"] = "Символы"
L["Glyphs are trade goods"] = "Символы это Хозяйственные товары"
L["HERB_BAG_TAG"] = "Тр"
L["Highlight color"] = "Цвет подсвечивания"
L["Highlight scale"] = "Масштаб подсвечивания"
L["INSCRIPTION_BAG_TAG"] = "Нч"
L["Item category"] = "Категория предмета"
L["Items"] = "Предметы"
L["Item search"] = "Поиск предмета"
L["Junk"] = "Хлам"
L["KEYRING_TAG"] = "Клч"
L["Layout priority"] = "Приоритет слоя"
L["LDB Plugin"] = "Плагин LDB"
L["LEATHERWORKING_BAG_TAG"] = "Кж"
L["Lock anchor"] = "Блокировать якорь"
L["Manual filtering"] = "Ручная фильтрация"
L["Maximum bag height"] = "Максимальная высота сумки"
L["Maximum row width"] = "Максимальная ширина ряда"
L["Merge bag types"] = "Объединить типы сумок"
L["MINING_BAG_TAG"] = "Гд"
L["Miscellaneous"] = "Разное"
L["Money"] = "Валюта"
L["New"] = "Новый"
L["New item highlight"] = "Подсвечивать новые предметы"
L["One section per set"] = "Одна секция на набор"
L["Only one section."] = "Только одна секция"
L["Other items"] = "Другие предметы"
L["Plugins"] = "Плагины"
L["Priority"] = "Приоритет"
L["Put ammunition and soul shards in their own sections."] = "Поместить боеприпасы и камни душ в свои секции."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Поместить все предметы которые могут быть одеты на персонажа (включая сумки) в секцию \"Экипировка\""
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Поместить предметы низкого качества или помеченных как хлам с секцию \"Хлам\"."
L["Put quest-related items in their own section."] = "Поместить предметы связанные с заданием в свою секцию."
L["Quality highlight"] = "Подсвечивать качества"
L["Quest"] = "Задания"
L["Quest indicator"] = "Индикатор задания"
L["Quest Items"] = "Предметы, необходимые для задания"
L["QUIVER_TAG"] = "Клчн"
L["Recipe"] = "Рецепты"
L["Reset new items"] = "Сброс новых предметов"
L["Reset position"] = "Сброс расположения"
L["Scale"] = "Масштаб"
L["Search:"] = "Поиск:"
L["Section setup"] = "Настройки секции"
L["Select how items should be sorted within each section."] = "Выберите как предметы должны сортироваться в пределах каждой секции."
L["Sets"] = "Наборы"
L["Set: %s"] = "Набор: %s"
L["Show bag type icons"] = "Показать иконку типа сумки"
L["Show bag type tags"] = "Показать тег типа сумки"
L["Show bank usage"] = "Показать использование банка"
L["Sorting order"] = "Порядок сортировки"
L["SOUL_BAG_TAG"] = "Кд"
L["Soul shards"] = "Камни душ"
L["Space in use"] = "Исп. места"
L["Space in use / total space"] = "Использовано / всего места"
L["Tidy bags"] = "Чистыйе сумки"
L["Toggle and configure item filters."] = "Переключение и настройка фильтров предмета."
L["Toggle and configure plugins."] = "Переключение и настройка плагина."
L["Tooltip information"] = "Информация подсказки"
L["Track new items"] = "Следить за новыми предметами"
L["Trade Goods"] = "Хозяйственные товары"
L["Uncheck this to disable AdiBags."] = "Снимите галочку штобы выключить AdiBags."
L["Unlock anchor"] = "Разблок. якорь"
L["Use this to adjust the bag scale."] = "Регулировка масштаба сумок."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Используете ето для настройки, на основе качества, границ прозрачности. 100% означает полностью непрозрачный"
L["Virtual stacks"] = "Виртуальные стопки"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Виртуальные стопки отображаютса в одном месте, предметы которые на самом деле распространяютса в нескольких сумачных слотаф."
L["Weapon"] = "Оружие"
L["When alt is held down"] = "Когда кнопка Alt нажата"
L["When any modifier key is held down"] = "Когда какая-либо клавиша модификатора нажата"
L["When ctrl is held down"] = "Когда кнопка Ctrl нажата"
L["When shift is held down"] = "Когда кнопка Shift нажата"

------------------------ esES ------------------------
-- no translation

------------------------ zhTW ------------------------
elseif locale == 'zhTW' then
L["Add association"] = "新增聯想"
L["AH category"] = "AH 種類"
L["AH subcategory"] = "AH 子種類"
L["Always"] = "一直"
L["Ammunition"] = "彈藥"
L["Ammunition and soul shards"] = "彈藥和靈魂裂片"
L["Are you sure you want to remove this association ?"] = "你確定要刪除此關聯?"
L["Armor"] = "護甲"
L["Backpack"] = "背包"
L["Bag number"] = "背包數量"
L["Bags"] = "背包"
L["Bag type"] = "背包類型"
L["Bag usage format"] = "背包使用格式"
L["Bank"] = "銀行"
L["By category, subcategory, quality and item level (default)"] = "按類別, 子類別, 品質和物品等級(預設值)"
L["By name"] = "按名字"
L["By quality and item level"] = "按品質和物品等級"
L["Category"] = "種類"
L["Check this to display a colored border around items, based on item quality."] = "選中來在物品邊框上按品質著色。"
L["Check this to display an icon after usage of each type of bags."] = "選中來在每個類型背包使用後顯示一個圖示。"
L["Check this to display an indicator on quest items."] = "選中來在任務物品上顯示一個指示。"
L["Check this to display an textual tag before usage of each type of bags."] = "選中來每個類型背包使用前顯示一個文本標記。"
L["Check this to show space at your bank in the plugin."] = "選中來在銀行中顯示背包空間。"
L["Check to enable this module."] = "選中來啟用這個模組。"
L["Click there to reset the bag positions and sizes."] = "點擊那兒來重置背包位置和尺寸。"
L["Click to purchase"] = "點擊購買"
L["Click to reset item status."] = "點擊重置物品狀態。"
L["Click to tidy bags."] = "點擊整理背包。"
L["Click to toggle the bag anchor."] = "點擊開啟或關閉背包錨點。"
L["Click to toggle the equipped bag panel, so you can change them."] = "點擊開啟或關閉已裝備背包面板, 用來修改他們。"
L["Close"] = "關閉"
L["Configure"] = "配置"
L["Consumable"] = "消耗品"
L["Container information"] = "容器資訊"
L["Currency"] = "貨幣"
L["Dim junk"] = "暗淡的垃圾"
L["Display character money at bottom right of the backpack."] = "在背包底部右側顯示玩家金錢。"
L["Drop your item there to add it to this section."] = "拖放你的物品到那來添加到這個分類部分。"
L["Enabled"] = "啟用"
L["Enter a text to search in item names."] = "輸入一個文本來搜索物品。"
L["Equipment"] = "裝備"
L["Equipped bags"] = "裝備背包"
L["Fill lines at most"] = "填充線至多"
L["Filter"] = "過濾"
L["Filtering information"] = "過濾資訊"
L["Filters"] = "篩檢程式"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "篩檢程式是用來在背包分類中調度物品。一件物品只能在一個分類中顯示。如果在多個篩檢程式中選中相同的物品, 最高優先順序的一個將勝出。"
L["Free space"] = "可用空間"
L["Free space / total space"] = "空間/總空間"
L["Gear manager item sets"] = "裝備管理物品設定"
L["Gem"] = "寶石"
L["Gems are trade goods"] = "寶石是貿易商品"
L["Glyph"] = "雕紋"
L["Glyphs are trade goods"] = "雕紋是貿易商品"
L["Highlight color"] = "高亮顏色"
L["Highlight scale"] = "高亮縮放"
L["Incomplete stacks"] = "不完整的堆疊"
L["Item"] = "物品"
L["Item category"] = "物品類別"
L["Item information"] = "物品資訊"
L["Items"] = "物品"
L["Item search"] = "物品搜索"
L["Jewelry"] = "飾品"
L["Junk"] = "垃圾"
L["Layout priority"] = "優先佈局"
L["LDB Plugin"] = "LDB 插件"
L["Lock anchor"] = "鎖定錨點"
L["Manual filtering"] = "手動過濾"
L["Maximum bag height"] = "最大高度的背包"
L["Maximum row width"] = "最大行寬度"
L["Maximum stack size"] = "最大的堆疊多少"
L["Merge bag types"] = "合併背包類型"
L["Merged sets"] = "合併設定"
L["Miscellaneous"] = "雜項"
L["Money"] = "金錢"
L["Never"] = "從不"
L["New"] = "新物品"
L["New item highlight"] = "新的物品高亮"
L["Only one section."] = "只有一節"
L["Other items"] = "其他物品"
L["Plugins"] = "插件"
L["Priority"] = "優先順序"
L["Quality highlight"] = "品質高亮"
L["Quest"] = "任務"
L["Quest indicator"] = "任務指示物"
L["Quest Items"] = "任務物品"
L["Recipe"] = "配方"
L["Reset new items"] = "重設新物品"
L["Reset position"] = "重設位置"
L["Scale"] = "縮放"
L["Search:"] = "搜尋:"
L["Section category"] = "科類"
L["Sets"] = "裝備設定"
L["Set: %s"] = "換裝設定: %s"
L["Show bag type icons"] = "顯示背包類型圖示"
L["Show bag type tags"] = "顯示背包類型標籤"
L["Show bank usage"] = "顯示銀行使用"
L["Show container information..."] = "顯示容器資訊"
L["Show filtering information..."] = "顯示過濾資訊..."
L["Show item information..."] = "顯示物品資訊"
L["Slot number"] = "槽數"
L["Sorting order"] = "排序"
L["Soul shards"] = "靈魂裂片"
L["Space in use"] = "空間使用"
L["Space in use / total space"] = "空間使用/總空間"
L["Split by subcategories"] = "子類別的分離"
L["Stackable items"] = "堆疊物品"
L["Tidy bags"] = "整理背包"
L["Tooltip information"] = "提示資訊"
L["Track new items"] = "追蹤新物品"
L["Trade Goods"] = "交易品"
L["Unlock anchor"] = "解鎖錨點"
L["Virtual stacks"] = "虛擬堆疊"
L["Weapon"] = "武器"
L["When alt is held down"] = "當 alt 按住"
L["When any modifier key is held down"] = "當任何修改鍵按住"
L["When ctrl is held down"] = "當 ctrl 按住"
L["When shift is held down"] = "當 shift 按住"

------------------------ zhCN ------------------------
elseif locale == 'zhCN' then
L["Add association"] = "增加组合"
L["AdiBags Anchor"] = "AdiBags 锚点"
L["Adjust the maximum height of the bags, relative to screen size."] = "调整背包最大高度，相对于屏幕尺寸"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "允许你手动更改物体应该放置的区域。把物体拽到区域标题处。"
L["Always"] = "总是"
L["Ammunition"] = "弹药"
L["Ammunition and soul shards"] = "弹药和灵魂碎片"
L["Anchored"] = "锚点"
L["Are you sure you want to remove this association ?"] = "您确定要移除这个组合？"
L["Armor"] = "护甲"
L["Background colors"] = "背景色"
L["Backpack"] = "背包"
L["Bag number"] = "背包数"
L["Bags"] = "背包"
L["Bag type"] = "背包类型"
L["Bag usage format"] = "背包使用格式"
L["Bank"] = "银行"
L["By category, subcategory, quality and item level (default)"] = "按类别, 子类别, 品质和物品等级(默认)"
L["By name"] = "按名字"
L["By quality and item level"] = "按品质和物品等级"
L["Category"] = "分类"
L["Check this to display a colored border around items, based on item quality."] = "选中来在物品边框上按品质着色。"
L["Check this to display an icon after usage of each type of bags."] = "选中来在每个类型背包使用后显示一个图标。"
L["Check this to display an indicator on quest items."] = "选中在任务物品上显示一个指示。"
L["Check this to display an textual tag before usage of each type of bags."] = "选中来每个类型背包使用前显示一个文本标记。"
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "选中来让所有装备包显示一个值，忽略类型。"
L["Check this to have poor quality items dimmed."] = "选中这低品质物品将变灰"
L["Check this to show space at your bank in the plugin."] = "选中在银行中显示背包空间。"
L["Check to enable this module."] = "选中启用这个模块。"
L["Click on this button to create the new association."] = "点击这个按钮将创建一个新的组合"
L["Click there to reset the bag positions and sizes."] = "点击重置背包位置和尺寸。"
L["Click to purchase"] = "点击购买"
L["Click to reset item status."] = "点击重置物品状态。"
L["Click to tidy bags."] = "点击整理背包。"
L["Click to toggle the bag anchor."] = "点击开启或关闭背包锚点。"
L["Click to toggle the equipped bag panel, so you can change them."] = "点击开启或关闭已装备背包面板, 用来修改他们。"
L["Close"] = "关闭"
L["Configure"] = "配置"
L["Consumable"] = "消耗品"
L["Container information"] = "容器信息"
L["Currency"] = "货币"
L["Dim junk"] = "灰色垃圾"
L["Display character currency at bottom left of the backpack."] = "在背包左侧显示金钱"
L["Display character money at bottom right of the backpack."] = "在背包底部右侧显示玩家金钱。"
L["Drop your item there to add it to this section."] = "拖放物品到这个分类。"
L["Enabled"] = "启用"
L["Enter a text to search in item names."] = "输入一个文本来搜索物品。"
L["Equipment"] = "装备"
L["Equipped bags"] = "已装备背包"
L["Filter"] = "过滤"
L["Filtering information"] = "过滤信息"
L["Filters"] = "过滤器"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "过滤器是用来在背包分类中调度物品。一件物品只能在一个分类中显示。如果在多个过滤器中选中相同的物品, 将使用最高优先级。"
L["Four general sections."] = "按4大类分组"
L["Free space"] = "空闲空间"
L["Free space / total space"] = "空闲 / 总空间"
L["Gear manager item sets"] = "套装管理"
L["Gem"] = "宝石"
L["Gems are trade goods"] = "宝石是商品"
L["Glyph"] = "铭文"
L["Glyphs are trade goods"] = "铭文是商品"
L["Highlight color"] = "高亮颜色"
L["Highlight scale"] = "高亮缩放"
L["Item"] = "物品"
L["Item category"] = "物品类别"
L["Item information"] = "物品信息"
L["Items"] = "物品"
L["Item search"] = "物品搜索"
L["Jewelry"] = "饰品"
L["Junk"] = "垃圾"
L["Layout priority"] = "优先布局"
L["LDB Plugin"] = "LDB 组件"
L["Lock anchor"] = "锁定锚点"
L["Manual"] = "手册"
L["Manual filtering"] = "手动过滤"
L["Maximum bag height"] = "最大背包高度"
L["Maximum row width"] = "最大行宽"
L["Maximum stack size"] = "最大堆叠大小"
L["Merge bag types"] = "合并背包类型"
L["Merged sets"] = "合并套装"
L["Miscellaneous"] = "杂项"
L["Money"] = "金钱"
L["Never"] = "从不"
L["New"] = "新物品"
L["New item highlight"] = "新物品高亮"
L["One section per item slot."] = "按套装、物品位置分组"
L["One section per set"] = "按套装分组"
L["Only one section."] = "一个分组"
L["Opacity"] = "透明度"
L["Other items"] = "其他物品"
L["Plugins"] = "组件"
L["Position mode"] = "定位模式"
L["Priority"] = "优先级"
L["Quality highlight"] = "品质高亮"
L["Quest"] = "任务"
L["Quest indicator"] = "任务指示器"
L["Quest Items"] = "任务物品"
L["Recipe"] = "配方"
L["Reset new items"] = "整理新物品"
L["Reset position"] = "重置位置"
L["Scale"] = "缩放"
L["Search:"] = "搜索:"
L["Section"] = "部分"
L["Semi-automated tidy"] = "半自动整理"
L["Sets"] = "套装"
L["Set: %s"] = "套装: %s"
L["Show bag type icons"] = "显示背包类型图标"
L["Show bag type tags"] = "显示背包类型标签"
L["Show bank usage"] = "显示银行使用"
L["Show container information..."] = "显示容器信息"
L["Show filtering information..."] = "显示过滤信息"
L["Show item information..."] = "显示物品信息"
L["Slot number"] = "槽数"
L["Sorting order"] = "分类顺序"
L["Soul shards"] = "灵魂碎片"
L["Space in use"] = "已使用空间"
L["Space in use / total space"] = "已使用空间 / 总空间"
L["Split armors by types"] = "按类型拆分护甲"
L["Split by subcategories"] = "按子类拆分"
L["Stackable items"] = "可堆叠物品"
L["Tidy bags"] = "整理背包"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = [=[点击背包右上的小"T"整理背包。
Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space.]=]
L["Toggle and configure item filters."] = "配置物品过滤"
L["Toggle and configure plugins."] = "配置组件"
L["Tooltip information"] = "提示信息"
L["Track new items"] = "新物品跟踪"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "跟踪背包中的新物品，新物品在\"新物品\"的区域它们都拥有一个光环，可以点击右上\"N\"按钮重置它们。"
L["Trade Goods"] = "商品"
L["Uncheck this to disable AdiBags."] = "反选禁用 AdiBags"
L["Unlock anchor"] = "解锁锚点"
L["Use this to adjust the bag scale."] = "使用这里调整背包缩放"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "使用这里调整品质背景透明度，100%是不透明"
L["Virtual stacks"] = "虚拟堆叠"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "虚拟堆叠显示一个位置，实际上在背包中占用多个位置。"
L["Weapon"] = "武器"
L["When alt is held down"] = "当 ALT 按下"
L["When any modifier key is held down"] = "当任何键按下"
L["When ctrl is held down"] = "当 CTRL 按下"
L["When shift is held down"] = "当 SHIFT 按下"

------------------------ koKR ------------------------
elseif locale == 'koKR' then
L["Add association"] = "연계체 추가"
L["Add more information in tooltips related to items in your bags."] = "가방안의 아이템과 관련된 툴팁에 더 많은 정보를 추가합니다."
L["AdiBags Anchor"] = "AdiBags 앵커"
L["Adjust the maximum height of the bags, relative to screen size."] = "화면 크기를 고려해, 가방의 최대 높이를 조절합니다."
L["Adjust the maximum number of items per row."] = "열당 아이템의 최대 갯수를 조절합니다."
L["AH category"] = "경매장 분류"
L["AH subcategory"] = "경매장 하위 분류"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "수동으로 아이템을 넣을 항목을 재정의할 수 있도록 합니다. 단순히 아이템을 잡아 끌어다 해당 항목 제목에 놓으세요."
L["Always"] = "항상"
L["AMMO_TAG"] = "탄"
L["Ammunition"] = "탄약"
L["Ammunition and soul shards"] = "탄약과 영혼의 조각"
L["Anchored"] = "앵커 지정"
L["Are you sure you want to remove this association ?"] = "정말로 관련된 이것을 제거하시겠습니까?"
L["Armor"] = "방어구"
L["Background colors"] = "배경 색상"
L["Backpack"] = "가방"
L["Bag number"] = "가방 수"
L["Bags"] = "가방"
L["Bag type"] = "가방 유형"
L["Bag usage format"] = "가방 사용칸수 형식"
L["Bank"] = "은행"
L["By category, subcategory, quality and item level (default)"] = "분류, 하위 분류, 등급과 아이템 레벨별(기본)"
L["By name"] = "이름별"
L["By quality and item level"] = "등급과 아이템 레벨별"
L["Category"] = "분류"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "고유의 \"세트\" 항목안에 병합되어질 세트를 체크하세요. 이것은 분명한 캐릭터별 설정입니다."
L["Check this so armors are dispatched in four sections by type."] = "방어구를 유형별로 4개의 항목안에 처리할 것 같으면 이것에 체크하십시요."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "전리품 획득창을 닫거나 상점. 우편함등을 벗어 난 경우에 정리를 수행할 것 같으면 이것에 체크하십시요."
L["Check this to display a bag type tag in the top left corner of items."] = "아이템의 상단 좌측 구석에 가방 유형 태그를 표시하려면 이것에 체크하세요."
L["Check this to display a colored border around items, based on item quality."] = "아이템 등급에 기반해, 아이템 주위에 색이 입혀진 테두리를 표시하려면 이것에 체크하세요."
L["Check this to display an icon after usage of each type of bags."] = "각 유형의 가방 사용칸수 뒤에 아이콘을 표시하려면 이것에 체크하세요."
L["Check this to display an indicator on quest items."] = "퀘스트 아이템에 지시기를 표시하려면 이것에 체크하세요."
L["Check this to display an textual tag before usage of each type of bags."] = "각 유형의 가방 사용칸수 앞에 문자 태그를 표시하려면 이것에 체크하세요."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "세트당 개별적인 하나의 항목을 표시하려면 이것에 체크하세요. 비활성화 한다면, 커다란 하나의 \"세트\" 항목이 될 것입니다."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "착용된 모든 가방을 그것의 유형을 무시한 체로, 단지 하나의 값으로 셈해 표시하려면 이것에 체크하세요. "
L["Check this to have poor quality items dimmed."] = "하급 아이템을 흐릿하게 하려면 이것에 체크하세요."
L["Check this to show space at your bank in the plugin."] = "플러그인 안에 은행에서의 칸수를 보여주려면 이것에 체크하세요."
L["Check to enable this module."] = "이 모듈을 사용하려면 체크하세요."
L["Click on this button to create the new association."] = "새로운 연결체를 생성하기 위해서 이 버튼을 클릭합니다."
L["Click there to reset the bag positions and sizes."] = "가방의 위치와 크기를 초기화하려면 거기를 클릭하세요."
L["Click to purchase"] = "구매하려면 클릭하세요."
L["Click to reset item status."] = "아이템 현황을 초기화하려면 클릭하세요."
L["Click to tidy bags."] = "가방을 정돈하려면 클릭하세요."
L["Click to toggle the bag anchor."] = "가방 앵커를 전환하려면 클릭하세요."
L["Click to toggle the equipped bag panel, so you can change them."] = "착용된 가방 패널을 전환하기 위해 클릭함으로써, 그것을 변경할 수 있습니다. "
L["Close"] = "닫기"
L["Configure"] = "설정"
L["Consider gems as a subcategory of trade goods"] = "직업용품의 하위분류로 보석을 고려"
L["Consider glyphs as a subcategory of trade goods"] = "직업용품의 하위분류로 문양을 고려"
L["Consumable"] = "소비용품"
L["Container information"] = "보관함 정보"
L["Currency"] = "화폐"
L["Dim junk"] = "잡동사니 흐릿하게 하기"
L["Display character currency at bottom left of the backpack."] = "가방의 하단 좌측에 캐릭터의 화폐를 표시합니다."
L["Display character money at bottom right of the backpack."] = "가방의 오른쪽 아래에 캐릭터의 소지금을 표시합니다."
L["Drop your item there to add it to this section."] = "이 항목으로 아이템을 추가하려면 거기에 아이템을 떨구세요."
L["Enabled"] = "사용"
L["ENCHANTING_BAG_TAG"] = "마부"
L["ENGINEERING_BAG_TAG"] = "기공"
L["Enter a text to search in item names."] = "아이템 이름에서 검색할 문자를 입력하세요."
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "항목과 연계하기 위한 아이템의 이름, 링크, 아이템 id를 입력합니다. 또한 이 박스안에 아이템을 떨굴 수 있습니다."
L["Enter the name of the section to associate with the item."] = "아이템과 연계하기 위한 항목의 이름을 입력합니다."
L["Equipment"] = "착용 장비"
L["Equipped bags"] = "착용된 가방"
L["Fill lines at most"] = "대부분 선 채우기"
L["Filter"] = "선별"
L["Filtering information"] = "선별하기 정보"
L["Filters"] = "선별기"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "선별기는 아이템을 각각의 가방 항목안에 처리하기 위해 사용됩니다. 하나의 항목에는 오로지 하나의 아이템만 표시될 수 있습니다.  만일 동일한 아이템이 몇가지 선별기에 의해 선택되었다면, 가장 높은 우선순위를 지닌 하나가 선택될 것입니다.    "
L["Four general sections."] = "네가지 공통 항목"
L["Free space"] = "빈 칸"
L["Free space / total space"] = "빈 칸 / 전체 칸"
L["Gear manager item sets"] = "장비 관리창 아이템 세트"
L["Gem"] = "보석"
L["GEM_BAG_TAG"] = "보"
L["Gems are trade goods"] = "보석은 직업용품"
L["Glyph"] = "문양"
L["Glyphs are trade goods"] = "문양은 직업용품"
L["Group sections of same category"] = "같은 분류의 항목 그룹화"
L["HERB_BAG_TAG"] = "약"
L["Highlight color"] = "색상 강조"
L["Highlight scale"] = "비율 강조"
L["Incomplete stacks"] = "불완전한 중첩"
L["INSCRIPTION_BAG_TAG"] = "주각"
L["Item"] = "아이템"
L["Item category"] = "아이템 분류"
L["Item information"] = "아이템 정보"
L["Items"] = "아이템"
L["Item search"] = "아이템 검색"
L["Jewelry"] = "보석류"
L["Junk"] = "잡동사니"
L["KEYRING_TAG"] = "열"
L["Layout priority"] = "레이아웃 우선순위"
L["LDB Plugin"] = "LDB 플러그인"
L["LEATHERWORKING_BAG_TAG"] = "가세"
L["Lock anchor"] = "앵커 잠그기"
L["Manual"] = "수동"
L["Manual filtering"] = "수동으로 선별하기"
L["Maximum bag height"] = "최대 가방 높이"
L["Maximum row width"] = "최대 열 너비"
L["Maximum stack size"] = "최대 중첩 크기"
L["Merge bag types"] = "가방 유형 병합"
L["Merged sets"] = "세트 병합"
L["MINING_BAG_TAG"] = "채광"
L["Miscellaneous"] = "기타"
L["Money"] = "소지금"
L["Never"] = "안함"
L["New"] = "새 아이템"
L["New item highlight"] = "새 아이템 강조"
L["New Override"] = "새것으로 덮어 쓰기"
L["One section per item slot."] = "아이템 칸당 한개의 항목"
L["One section per set"] = "세트당 한개의 항목"
L["Only one section."] = "오직 한개의 항목"
L["Opacity"] = "불투명도"
L["Other items"] = "기타 아이템"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "이 선별기에 일치하는 모든 아이템에 주의하기 바랍니다. 이것보다 더 낮은 우선순위를 지닌 어떠한 선별기도 영향을 주지 못할 것입니다."
L["Plugins"] = "플러그인"
L["Position mode"] = "위치 모드"
L["Priority"] = "우선순위"
L["Provides a LDB data source to be displayed by LDB display addons."] = "LDB 표시 애드온에 의해 표시될 수 있도록 LDB 원자료를 제공합니다. "
L["Provides a text widget at top of the backpack where you can type (part of) an item name to locate it in your bags."] = "가방 상단에 가방 안에 위치시키기 위해 아이템 이름(의 일부)을 입력할 수 있는 문자 장치를 제공합니다."
L["Put ammunition and soul shards in their own sections."] = "탄약과 영혼의 조각을 그 자신의 항목에 집어 넣습니다."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "착용할 수 있는 모든 아이템(가방을 포함한)을 \"착용 장비\" 항목에 집어 넣습니다."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "내장된 장비 관리창의 하나 혹은 그 이상의 세트에 속해 있는 아이템을 해당 항목에 집어 넣습니다."
L["Put items in sections depending on their first-level category at the Auction House."] = "경매장에서 그것의 첫번째 레벨 분류에 의존하는 항목안에 아이템을 집어 넣습니다."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "하위 등급 혹은 잡동사니로 이름 붙여진 아이템을 \"잡동사니\" 항목에 집어 넣습니다."
L["Put quest-related items in their own section."] = "퀘스트와 관련된 아이템을 그 자신의 항목에 집어 넣습니다."
L["Quality highlight"] = "등급 강조"
L["Quest"] = "퀘스트"
L["Quest indicator"] = "퀘스트 지시기"
L["Quest Items"] = "퀘스트 아이템"
L["QUIVER_TAG"] = "화"
L["Recipe"] = "제조법"
L["Reset new items"] = "새 아이템 초기화"
L["Reset position"] = "위치 초기화"
L["Scale"] = "비율"
L["Search:"] = "검색:"
L["Section"] = "항목"
L["Section category"] = "항목 분류"
L["Section setup"] = "항목 설정"
L["Select how bag usage should be formatted in the plugin."] = "플러그인에 가방 사용칸수를 어떻게 형식화할 것인지를 선택합니다."
L["Select how items should be sorted within each section."] = "각 항목내에서 아이템을 어떻게 정리할 것인지를 선택합니다."
L["Select how the bag are positionned."] = "가방을 위치지울 방식을 선택합니다."
L["Select the category of the section to associate. This is used to group sections together."] = "연계하기 위한 항목의 분류를 선택합니다."
L["Select the sections in which the items should be dispatched."] = "아이템을 처리하게 될 항목을 선택합니다."
L["Select which first-level categories should be split by sub-categories."] = "하위 분류에 의해 나눠져야 할 첫번째 레벨 분류를 선택합니다."
L["Semi-automated tidy"] = "반자동 정리"
L["Sets"] = "세트"
L["Set: %s"] = "세트 : %s"
L["Show bag type icons"] = "가방 유형 아이콘 보이기"
L["Show bag type tags"] = "가방 유형 태그 보이기"
L["Show bank usage"] = "은행 사용칸수 보이기"
L["Show container information..."] = "보관함의 정보를 보입니다."
L["Show filtering information..."] = "선별하기 정보를 보입니다."
L["Show item information..."] = "아이템 정보를 보입니다."
L["Slot number"] = "칸수"
L["Sorting order"] = "정리 순서"
L["SOUL_BAG_TAG"] = "조각"
L["Soul shards"] = "영혼의 조각"
L["Space in use"] = "사용된 칸수"
L["Space in use / total space"] = "사용된 칸수/전체 칸수"
L["Split armors by types"] = "유형별로 방어구 분리"
L["Split by subcategories"] = "하위 분류에 따라 분리"
L["Stackable items"] = "중첩이 가능한 아이템"
L["Strictly keep ordering"] = "엄격히 순서 유지"
L["Tidy bags"] = "가방 정리"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "가방 상단 좌측에 작은 \"T\" 버튼을 클릭함으로써 가방을 정리합니다. 빈 칸의 전문 가방은 합당한 아이템으로 채워질 것이며 칸을 절약하기 위해 중첩이 가능한 아이템은 겹쳐질 것입니다."
L["Toggle and configure item filters."] = "아이템 선별 전환 및 설정"
L["Toggle and configure plugins."] = "플러그인 전환 및 설정"
L["Tooltip information"] = "툴팁 정보"
L["Track new items"] = "새 아이템 추적"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "각 가방에 있는 새로운 아이템을 추적해, 광이 나는 오라로 표시하고 별도의 항목에 집어 넣을 것입니다. \"새 아이템\" 상태는 가방 상단 좌측의 작은 \"N\" 버튼을 클릭하는 것으로 초기화할 수 있습니다, "
L["Trade Goods"] = "직업용품"
L["Uncheck this to disable AdiBags."] = "AdiBags를 비활성화하려면 이것을 체크 해제 하십시요."
L["Unlock anchor"] = "앵커의 잠금 해제"
L["Use this section to define any item-section association."] = "특정 아이템 항목의 연계성을 재정의하기 위해서 이 항목을 사용합니다."
L["Use this to adjust the bag scale."] = "가방 비율을 조절하려면 이것을 사용하세요."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "등급에 기반한 테두리 불투명도를 조절하려면 이것을 사용하세요. 100%는 꽉찬 투명도를 의미합니다. "
L["Virtual stacks"] = "가상 스택"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "실제로 가방의 여러 공간을 차지하는 아이템을 가상 스택을 사용해서 한칸으로 표시합니다."
L["Weapon"] = "무기"
L["When alt is held down"] = "alt 키를 누르고 있는 경우"
L["When any modifier key is held down"] = "특정 변경키를 누르고 있는 경우"
L["When ctrl is held down"] = "ctrl 키를 누르고 있는 경우"
L["When shift is held down"] = "shift 키를 누르고 있는 경우"
end

-- @noloc]]

-- Replace remaining true values by their key
for k,v in pairs(L) do if v == true then L[k] = k end end
